package com.fullStackBlogs.OrderService.Controller;

import java.util.UUID;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import com.fullStackBlogs.BaseDomain.DTO.Order;
import com.fullStackBlogs.BaseDomain.DTO.OrderEvent;
import com.fullStackBlogs.OrderService.Service.OrderProducer;

@RestController
@RequestMapping("api/v1")
public class OrderController {

	@Autowired
	private OrderProducer orderProducer;
	
	@PostMapping(value = "/order")
	public String placeOrder(@RequestBody Order order) {
		order.setOrderId(UUID.randomUUID().toString());
		
		OrderEvent orderEvent = new OrderEvent();
		orderEvent.setStatus("PENDING");
		orderEvent.setMessage("Order Status is in pending state");
		orderEvent.setOrder(order);
		
		// Send Message
		orderProducer.sendMessage(orderEvent);
		return "Order placed successfully";
	}
}
