/*
 * Decompiled with CFR 0.152.
 */
package zipkin2.server.internal.throttle;

import brave.Tracer;
import brave.Tracing;
import brave.propagation.CurrentTraceContext;
import com.linecorp.armeria.common.util.Exceptions;
import com.netflix.concurrency.limits.Limit;
import com.netflix.concurrency.limits.limit.Gradient2Limit;
import com.netflix.concurrency.limits.limiter.AbstractLimiter;
import io.micrometer.core.instrument.MeterRegistry;
import java.io.IOException;
import java.util.Objects;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import zipkin2.internal.Nullable;
import zipkin2.server.internal.throttle.LimiterMetrics;
import zipkin2.server.internal.throttle.MicrometerThrottleMetrics;
import zipkin2.server.internal.throttle.ThrottledStorageComponent;
import zipkin2.storage.ForwardingStorageComponent;
import zipkin2.storage.SpanConsumer;
import zipkin2.storage.StorageComponent;

/*
 * Exception performing whole class analysis ignored.
 */
public final class ThrottledStorageComponent
extends ForwardingStorageComponent {
    static final RejectedExecutionException STORAGE_THROTTLE_MAX_QUEUE_SIZE = (RejectedExecutionException)Exceptions.clearTrace((Throwable)new RejectedExecutionException("STORAGE_THROTTLE_MAX_QUEUE_SIZE reached"));
    final StorageComponent delegate;
    @Nullable
    final Tracer tracer;
    @Nullable
    final CurrentTraceContext currentTraceContext;
    final AbstractLimiter<Void> limiter;
    final ThreadPoolExecutor executor;
    final LimiterMetrics limiterMetrics;

    public ThrottledStorageComponent(StorageComponent delegate, MeterRegistry registry, @Nullable Tracing tracing, int minConcurrency, int maxConcurrency, int maxQueueSize) {
        this.delegate = Objects.requireNonNull(delegate);
        this.tracer = tracing != null ? tracing.tracer() : null;
        this.currentTraceContext = tracing != null ? tracing.currentTraceContext() : null;
        Gradient2Limit limit = Gradient2Limit.newBuilder().minLimit(minConcurrency).initialLimit(minConcurrency).maxConcurrency(maxConcurrency).queueSize(0).build();
        this.limiter = ((Builder)new Builder().limit((Limit)limit)).build();
        this.executor = new ThreadPoolExecutor(limit.getLimit(), limit.getLimit(), 0L, TimeUnit.DAYS, ThrottledStorageComponent.createQueue((int)maxQueueSize), (ThreadFactory)new /* Unavailable Anonymous Inner Class!! */, (r, e) -> {
            throw STORAGE_THROTTLE_MAX_QUEUE_SIZE;
        });
        limit.notifyOnChange((Consumer)new ThreadPoolExecutorResizer(this.executor));
        MicrometerThrottleMetrics metrics = new MicrometerThrottleMetrics(registry);
        metrics.bind(this.executor);
        metrics.bind(this.limiter);
        this.limiterMetrics = new LimiterMetrics(registry);
    }

    protected StorageComponent delegate() {
        return this.delegate;
    }

    public SpanConsumer spanConsumer() {
        return new ThrottledSpanConsumer(this);
    }

    public void close() throws IOException {
        this.executor.shutdownNow();
        this.delegate.close();
    }

    public String toString() {
        return "Throttled{" + this.delegate.toString() + "}";
    }

    static BlockingQueue<Runnable> createQueue(int maxSize) {
        if (maxSize < 0) {
            throw new IllegalArgumentException("maxSize < 0");
        }
        if (maxSize == 0) {
            maxSize = 1;
        }
        return new LinkedBlockingQueue<Runnable>(maxSize);
    }
}

