/*
 * Decompiled with CFR 0.152.
 */
package zipkin2.server.internal.elasticsearch;

import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import zipkin2.internal.Nullable;
import zipkin2.server.internal.elasticsearch.BasicCredentials;

/*
 * Exception performing whole class analysis ignored.
 */
class DynamicCredentialsFileLoader
implements Runnable {
    static final Logger LOGGER = LoggerFactory.getLogger(DynamicCredentialsFileLoader.class);
    private final String credentialsFile;
    private final BasicCredentials basicCredentials;

    public DynamicCredentialsFileLoader(BasicCredentials basicCredentials, String credentialsFile) {
        this.basicCredentials = basicCredentials;
        this.credentialsFile = credentialsFile;
    }

    @Override
    public void run() {
        try {
            this.updateCredentialsFromProperties();
        }
        catch (Exception e) {
            LOGGER.error("Error loading elasticsearch credentials", (Throwable)e);
        }
    }

    void updateCredentialsFromProperties() throws IOException {
        Properties properties = new Properties();
        try (FileInputStream is = new FileInputStream(this.credentialsFile);){
            properties.load(is);
        }
        String username = DynamicCredentialsFileLoader.ensureNotEmptyOrNull((Properties)properties, (String)this.credentialsFile, (String)"zipkin.storage.elasticsearch.username");
        String password = DynamicCredentialsFileLoader.ensureNotEmptyOrNull((Properties)properties, (String)this.credentialsFile, (String)"zipkin.storage.elasticsearch.password");
        this.basicCredentials.updateCredentials(username, password);
    }

    @Nullable
    static String ensureNotEmptyOrNull(Properties properties, String fileName, String name) {
        String value = properties.getProperty(name);
        if (value == null) {
            throw new IllegalStateException("no " + name + " property in " + fileName);
        }
        if ("".equals(value = value.trim())) {
            throw new IllegalStateException("empty " + name + " property in " + fileName);
        }
        return value;
    }
}

