/*
 * Decompiled with CFR 0.152.
 */
package zipkin2.server.internal;

import com.linecorp.armeria.client.encoding.StreamDecoderFactory;
import com.linecorp.armeria.common.AggregatedHttpRequest;
import com.linecorp.armeria.common.HttpData;
import com.linecorp.armeria.common.HttpHeaderNames;
import com.linecorp.armeria.server.ServiceRequestContext;
import zipkin2.server.internal.ZipkinHttpCollector;

final class UnzippingBytesRequestConverter {
    UnzippingBytesRequestConverter() {
    }

    static HttpData convertRequest(ServiceRequestContext ctx, AggregatedHttpRequest request) {
        ZipkinHttpCollector.metrics.incrementMessages();
        String encoding = request.headers().get((CharSequence)HttpHeaderNames.CONTENT_ENCODING);
        HttpData content = request.content();
        if (!content.isEmpty() && encoding != null && encoding.contains("gzip") && (content = StreamDecoderFactory.gzip().newDecoder(ctx.alloc()).decode(content)).isEmpty()) {
            ZipkinHttpCollector.maybeLog((String)"Malformed gzip body", (ServiceRequestContext)ctx, (AggregatedHttpRequest)request);
            content.close();
            throw new IllegalArgumentException("Cannot gunzip spans");
        }
        if (content.isEmpty()) {
            ZipkinHttpCollector.maybeLog((String)"Empty POST body", (ServiceRequestContext)ctx, (AggregatedHttpRequest)request);
        }
        if (content.length() == 2 && "[]".equals(content.toStringAscii())) {
            ZipkinHttpCollector.maybeLog((String)"Empty JSON list POST body", (ServiceRequestContext)ctx, (AggregatedHttpRequest)request);
            content.close();
            content = HttpData.empty();
        }
        ZipkinHttpCollector.metrics.incrementBytes(content.length());
        return content;
    }
}

