package com.fullStackBlogs.employeeService.serviceImpl;

import java.util.List;

import org.modelmapper.ModelMapper;
import org.modelmapper.TypeToken;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.fullStackBlogs.employeeService.dto.EmployeeDto;
import com.fullStackBlogs.employeeService.repository.EmployeeRepository;
import com.fullStackBlogs.employeeService.service.EmployeeService;


@Service
public class EmployeeServiceImpl implements EmployeeService{
	
	@Autowired
	private EmployeeRepository employeeRepository;
	
	@Autowired
	private ModelMapper modelMapper;

	@Override
	public List<EmployeeDto> getAllEmployee() {
		return modelMapper.map(employeeRepository.findAll(), new TypeToken<List<EmployeeDto>>() {}.getType());
	}

}
