package com.fullStackBlogs.customerService.controller;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import com.fullStackBlogs.customerService.Service.CustomerService;
import com.fullStackBlogs.customerService.Service.EmployeeService;
import com.fullStackBlogs.customerService.dto.CustomerDto;
import com.fullStackBlogs.customerService.dto.EmployeeDto;

@RestController
@RequestMapping("api/v1")
@RefreshScope
public class Customer {
	
	@Value("${serviceName}")
	private String serviceName;
	
	@Autowired
	private CustomerService customerService;
	
	@Autowired
	private EmployeeService employeeService;
	
	@GetMapping(value = "customers")
	public List<CustomerDto> getAllCustomer() {
		return customerService.getAllCustomer();
	}
	
	@GetMapping(value = "employeeList")
	public List<EmployeeDto> getAllEmployee(){
		return employeeService.getAllEmployee();
	}
	
	@GetMapping(value = "serviceName")
	public String getServiceName() {
		return serviceName;
	}

}
