package com.fullStackBlogs.customerService.ServiceImpl;

import java.util.List;

import org.modelmapper.ModelMapper;
import org.modelmapper.TypeToken;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.fullStackBlogs.customerService.Service.CustomerService;
import com.fullStackBlogs.customerService.dto.CustomerDto;
import com.fullStackBlogs.customerService.repository.CustomerRepository;

@Service
public class CustomerServiceImpl implements CustomerService {
	
	@Autowired
	private CustomerRepository customerRepository;
	
	@Autowired
	private ModelMapper modelMapper;

	@Override
	public List<CustomerDto> getAllCustomer() {
		return modelMapper.map(customerRepository.findAll(), new TypeToken<List<CustomerDto>>() {}.getType());
	}

}
