package com.fullStackBlogs.customerService.controller;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import com.fullStackBlogs.customerService.Service.CustomerService;
import com.fullStackBlogs.customerService.Service.EmployeeService;
import com.fullStackBlogs.customerService.dto.CustomerDto;
import com.fullStackBlogs.customerService.dto.EmployeeDto;

@RestController
@RequestMapping("api/v1")
public class Customer {
	
	@Autowired
	private CustomerService customerService;
	
	@Autowired
	private EmployeeService employeeService;
	
	@GetMapping(value = "customers")
	public List<CustomerDto> getAllCustomer() {
		return customerService.getAllCustomer();
	}
	
	@GetMapping(value = "employeeList")
	public List<EmployeeDto> getAllEmployee(){
		return employeeService.getAllEmployee();
	}

}
